<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 dark:text-gray-200 leading-tight">
            {{ __('Criar Município') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900 dark:text-gray-100">
                    <form action="{{route('municipio.create')}}" method="POST">

                        @if (@$mensagem[0]!='')
                            <div class="w-full my-4 p-2 border rounded" style="background-color: green; border-color: green; color: green">
                                {{ $mensagem[0] }}
                            </div>
                        @endif
                        <div class="w-full mb-6">
                            <label for="">Província*</label>
                            <select value="{{ old('provincia') }}" class="w-full border border-gray-700 rounded" required name="provincia" id="provincia">
                                @forelse ($provincias as $item)
                                    <option value="{{$item->id}}">{{$item->nome}}</option>
                                @empty
                                    <option @disabled(true) value="">Nenhuma província cadastrada</option>
                                @endforelse
                                
                            </select>
                            @error('provincia')
                                <div class="w-full my-4 p-2 border rounded" style="background-color: #f28d75; border-color: #e5322d; color:  #e7322d">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>
                        <div class="w-full mb-6">
                            <label for="">Nome do Município*</label>
                            <input class="w-full border border-gray-700 rounded" required type="text" name="nome" id="nome" value="{{ old('nome') }}">
                            @error('nome')
                                <div class="w-full my-4 p-2 border rounded" style="background-color: #f28d75; border-color: #e5322d; color:  #e7322d">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>
                        <div class="w-full mb-6">
                            <label for="">Código</label>
                            <input class="w-full border border-gray-700 rounded" type="text" name="codigo" id="codigo" value="{{ old('codigo') }}">
                            @error('codigo')
                                <div class="w-full my-4 p-2 border rounded" style="background-color: #f28d75; border-color: #e5322d; color:  #e7322d">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>
                        <div class="w-full mb-6">
                            <label for="">Latitude</label>
                            <input class="w-full border border-gray-700 rounded" type="text" name="lat" id="lat" value="{{ old('lat') }}">
                            @error('lat')
                                <div class="w-full my-4 p-2 border rounded" style="background-color: #f28d75; border-color: #e5322d; color:  #e7322d">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>
                        <div class="w-full mb-6">
                            <label for="">Longitude</label>
                            <input class="w-full border border-gray-700 rounded" type="text" name="long" id="long" value="{{ old('long') }}">
                            @error('long')
                                <div class="w-full my-4 p-2 border rounded" style="background-color: #f28d75; border-color: #e5322d; color:  #e7322d">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>
                        <div class="w-full mb-6">
                            <label for="">Precisão (Metros)</label>
                            <input class="w-full border border-gray-700 rounded" type="text" name="precision" id="precision" value="{{ old('precision') }}">
                            @error('precision')
                                <div class="w-full my-4 p-2 border rounded" style="background-color: #f28d75; border-color: #e5322d; color:  #e7322d">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>
                        <div class="w-full mb-6">
                            <label for="">Responsável do Município*</label>
                            <select value="{{ old('user') }}" class="w-full border border-gray-700 rounded" required name="user" id="user">
                                @forelse ($users as $item)
                                    <option value="{{$item->id}}">{{$item->name}} ({{$item->role}})</option>
                                @empty
                                    <option @disabled(true) value="">Nenhum usuário cadastrado</option>
                                @endforelse
                                
                            </select>
                            @error('user')
                                <div class="w-full my-4 p-2 border rounded" style="background-color: #f28d75; border-color: #e5322d; color:  #e7322d">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>
                        <button class="px-4 py-2 rounded border text-white border-green-900 bg-green-700 hover:bg-green-900 
                        transition duration-300 ease-in-out" type="submit">Salvar</button>
                        @csrf
                    </form>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>
